package javabeans;

import java.util.Set;
import java.util.HashSet;

public class PointChaud
{
	private double temperature;

	private Set<TempChangeListener> tempChangeListeners = new HashSet<TempChangeListener>();

	public PointChaud(double temperature) {
		this.temperature = temperature;
	}

	public PointChaud(){
		this(0);
	}
	
	public double getPointChaud() {
		return temperature;
	}
	
	public void setPointChaud(double temperature) {
		this.temperature = temperature;
		this.notifyTemperatureChange();
	}

	public synchronized void addTempChangeListener(TempChangeListener tempChangeListener) {
			tempChangeListeners.add(tempChangeListener);
	}

	public synchronized void removeTempChangeListener(TempChangeListener tempChangeListener) {
			tempChangeListeners.remove(tempChangeListener);
	}

	@SuppressWarnings("unchecked")
	public void notifyTemperatureChange() {
		TempChangedEvent event = new TempChangedEvent(this, temperature);

		Set<TempChangeListener> clone;
		synchronized(this) {
			clone = (Set<TempChangeListener>) ((HashSet<TempChangeListener>) tempChangeListeners).clone();
		}

		for (TempChangeListener tempChangeListener : clone) {
			tempChangeListener.tempChanged(event);
		}
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime
				* result
				+ ((tempChangeListeners == null) ? 0 : tempChangeListeners
						.hashCode());
		long temp;
		temp = Double.doubleToLongBits(temperature);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		PointChaud other = (PointChaud) obj;
		if (tempChangeListeners == null) {
			if (other.tempChangeListeners != null)
				return false;
		} else if (!tempChangeListeners.equals(other.tempChangeListeners))
			return false;
		if (Double.doubleToLongBits(temperature) != Double
				.doubleToLongBits(other.temperature))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "(Temperature : " + temperature + ", " + tempChangeListeners + ")";
	}
}
